<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<?xml version="1.0" encoding="UTF-8"?>
<configuration debug="false">
    <property name="LOG_PATH" value="logs" />
    <property name="LOG_PATTERN" value="%d{yyyy-MM-dd HH:mm:ss.SSS} [%-5level] %-40.40logger{39} : %msg%n" />
    <!-- 彩色日志 -->
    <!-- 彩色日志依赖的渲染类 -->
    <conversionRule conversionWord="clr" converterClass="org.springframework.boot.logging.logback.ColorConverter" />
    <conversionRule conversionWord="wex" converterClass="org.springframework.boot.logging.logback.WhitespaceThrowableProxyConverter" />
    <conversionRule conversionWord="wEx" converterClass="org.springframework.boot.logging.logback.ExtendedWhitespaceThrowableProxyConverter" />
    <!-- 彩色日志格式 -->
    <property name="LOG_PATTERN2" value="${r'${CONSOLE_LOG_PATTERN:-%clr(%d{yyyy-MM-dd HH:mm:ss.SSS}){faint} %clr([${LOG_LEVEL_PATTERN:-%5p}]) %clr(%-40.40logger{39}){cyan} %clr(:){faint} %m%n${LOG_EXCEPTION_CONVERSION_WORD:-%wEx}}'}" />

    <!-- 控制台输出 -->
    <appender name="Console" class="ch.qos.logback.core.ConsoleAppender">
        <encoder class="ch.qos.logback.classic.encoder.PatternLayoutEncoder">
            <pattern>${r'${LOG_PATTERN}'}</pattern>
        </encoder>
    </appender>
<#--<!-- LOGSTASH &ndash;&gt;-->
<#--<appender name="LOGSTASH"-->
<#--          class="net.logstash.logback.appender.LogstashTcpSocketAppender">-->
<#--    <destination>172.16.102.211:9601</destination>-->
<#--    <encoder charset="UTF-8" class="net.logstash.logback.encoder.LogstashEncoder">-->
<#--        <customFields>{"appname":"${app.getPKGCodeName()?lower_case}"}</customFields>-->
<#--    </encoder>-->
<#--</appender>-->
    <!-- 按照每天生成日志文件 -->
    <appender name="file"  class="ch.qos.logback.core.rolling.RollingFileAppender">
        <rollingPolicy class="ch.qos.logback.core.rolling.TimeBasedRollingPolicy">
            <!--日志文件输出的文件名-->
            <FileNamePattern>${r'${LOG_PATH}'}/${sys.getCodeName()?lower_case}.%d{yyyy-MM-dd}.%i.log</FileNamePattern>
            <!--日志文件最大的大小-->
            <timeBasedFileNamingAndTriggeringPolicy class="ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP">
                <maxFileSize>100MB</maxFileSize>
            </timeBasedFileNamingAndTriggeringPolicy>
            <!--日志文件保留天数-->
            <MaxHistory>30</MaxHistory>
        </rollingPolicy>
        <encoder class="ch.qos.logback.classic.encoder.PatternLayoutEncoder">
            <pattern>${r'${LOG_PATTERN}'}</pattern>
        </encoder>
    </appender>
    <!-- 日志输出级别 -->
    <root level="INFO">
        <appender-ref ref="Console" />
        <appender-ref ref="file" />
    <#--    <appender-ref ref="LOGSTASH" />-->
    </root>
</configuration>
